import React, { useEffect } from "react";
import { createBottomTabNavigator } from "@react-navigation/bottom-tabs";
import { createNativeStackNavigator } from "@react-navigation/native-stack";
import {
  NavigationContainer,
  getFocusedRouteNameFromRoute,
} from "@react-navigation/native";
import { Cog8ToothIcon } from "react-native-heroicons/solid";
import { Cog8ToothIcon as Cog8ToothIconOutline } from "react-native-heroicons/outline";
import { COLORS } from "../styles/colors";
import { Ionicons } from "@expo/vector-icons";
import Users from "../screens/Users/Users";
import Categories from "../screens/Categories/Categories";
import EditCategory from "../screens/Categories/EditCategory";
import SendNotifications from "../screens/Users/SendNotifications";
import Home from "../screens/Home";
import Searchs from "../screens/Searchs/Searchs";
import SearchDetails from "../screens/Searchs/SearchDetails";
import UserDetails from "../screens/Users/UserDetails";
import FindedSearchs from "../screens/Searchs/FindedSearchs";
import Payments from "../screens/Payments/Payments";

const Stack = createNativeStackNavigator();
const Tab = createBottomTabNavigator();

const NAV_ICON_DEFAULT_SIZE = 20;
export default function Navigatorrrr() {
  const HomeStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Home" component={Home} />
      </Stack.Navigator>
    );
  };

  const PaymentsStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Payments" component={Payments} options={{title:"Paiements"}} />
      </Stack.Navigator>
    );
  };

  const SearchsStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Searchs" component={Searchs} />
        <Stack.Screen name="SearchDetails" component={SearchDetails} />
      </Stack.Navigator>
    );
  };

  const FindedSearchsStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="FindedSearchs" component={FindedSearchs} />
        <Stack.Screen name="SearchDetails" component={SearchDetails} />
      </Stack.Navigator>
    );
  };

  const UsersStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Users" component={Users} />
        <Stack.Screen name="UserDetails" component={UserDetails} />
        <Stack.Screen name="SendNotifications" component={SendNotifications} />
      </Stack.Navigator>
    );
  };

  const CategoriesStack = () => {
    return (
      <Stack.Navigator
        screenOptions={{
          headerStyle: { borderColor: "white" },
          contentStyle: { backgroundColor: "white" },
          headerTitleStyle: { fontFamily: "Inter_500Medium" },
        }}
      >
        <Stack.Screen name="Categories" component={Categories} />
        <Stack.Screen name="EditCategory" component={EditCategory} />
      </Stack.Navigator>
    );
  };

  return (
    <NavigationContainer>
      <Tab.Navigator
        screenOptions={{
          tabBarActiveTintColor: COLORS.primary,
          headerShown: false,
          tabBarShowLabel: true,
          tabBarLabelStyle: {
            fontSize: 9,
            fontFamily: "Inter_300Light",
          },
        }}
      >
        <Tab.Screen
          name="HomeTab"
          component={HomeStack}
          options={{
            title: "Accueil",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="home"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="home-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />
        <Tab.Screen
          name="PaymentsTab"
          component={PaymentsStack}
          options={{
            title: "Paiements",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="card"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="card-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />

        <Tab.Screen
          name="SearchsTab"
          component={SearchsStack}
          options={{
            title: "Véhicules",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="search"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="search-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />
        <Tab.Screen
          name="FindedSearchsTab"
          component={FindedSearchsStack}
          options={{
            title: "Retrouvés",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="checkmark"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="checkmark-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />
        <Tab.Screen
          name="UsersTab"
          component={UsersStack}
          options={{
            title: "Utilisateurs",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  color={COLORS.primary}
                  name="person"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ) : (
                <Ionicons
                  color={"#2d3436"}
                  name="person-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                />
              ),
          }}
        />
        <Tab.Screen
          name="CategoriesTab"
          component={CategoriesStack}
          options={{
            title: "Categories",
            tabBarIcon: ({ focused }) =>
              focused ? (
                <Ionicons
                  name="apps"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color={COLORS.primary}
                />
              ) : (
                <Ionicons
                  name="apps-outline"
                  size={NAV_ICON_DEFAULT_SIZE}
                  color="#2d3436"
                />
              ),
          }}
        />
      </Tab.Navigator>
    </NavigationContainer>
  );
}
